/*!
 * Bootstrap v2.0.2
 *
 * Copyright 2012 Twitter, Inc
 * Licensed under the Apache License v2.0
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Designed and built with all the love in the world @twitter by @mdo and @fat.
 */
@import "variables.less"; // Modify this for custom colors, font-sizes, etc
@import "mixins.less";

@colorset:#<?=$_GET['mColor']?> ;
@navbarBackgroundHighlight:@colorset;
@navbarBackground:darken(@colorset, 6.5%);
@navbarText:@white;
@brandColor:#<?=$_GET['tColor']?>;
@brandWeight:400;
@navbarSearchPlaceholderColor:#eee;
@navbarLinkColor:#<?=$_GET['mtColor']?>;
@navbarLinkColorHover:@white;

// NAVBAR (FIXED AND STATIC)
// -------------------------


// COMMON STYLES
// -------------

.navbar {
  // Fix for IE7's bad z-indexing so dropdowns don't appear below content that follows the navbar
  *position: relative;
  *z-index: 2;

  overflow: visible;
  margin-bottom: @baseLineHeight;
}

// Gradient is applied to it's own element because overflow visible is not honored by IE when filter is present
.navbar-inner {
  padding-left:  20px;
  padding-right: 20px;
  #gradient > .vertical(@navbarBackgroundHighlight, @navbarBackground);
  .border-radius(4px);
  @shadow: 0 1px 3px rgba(0,0,0,.25), inset 0 -1px 0 rgba(0,0,0,.1);
  .box-shadow(@shadow);
}

// Set width to auto for default container
// We then reset it for fixed navbars in the #gridSystem mixin
.navbar .container {
  width: auto;
}

// Navbar button for toggling navbar items in responsive layouts
.btn-navbar {
  display: none;
  float: right;
  padding: 7px 10px;
  margin-left: 5px;
  margin-right: 5px;
  .buttonBackground(@navbarBackgroundHighlight, @navbarBackground);
  @shadow: inset 0 1px 0 rgba(255,255,255,.1), 0 1px 0 rgba(255,255,255,.075);
  .box-shadow(@shadow);
}
.btn-navbar .icon-bar {
  display: block;
  width: 18px;
  height: 2px;
  background-color: #f5f5f5;
  .border-radius(1px);
  .box-shadow(0 1px 0 rgba(0,0,0,.25));
}
.btn-navbar .icon-bar + .icon-bar {
  margin-top: 3px;
}
// Override the default collapsed state
.nav-collapse.collapse {
  height: auto;
}


// Brand, links, text, and buttons
.navbar {
  color: @navbarText;
  // Hover and active states
  .brand:hover {
    text-decoration: none;
  }
  // Website or project name
  .brand {
    float: left;
    display: block;
    padding: 8px 20px 12px;
    margin-left: -20px; // negative indent to left-align the text down the page
    font-size: 20px;
    font-weight: @brandWeight;
    line-height: 1;
    color: @brandColor;
  }
  // Plain text in topbar
  .navbar-text {
    margin-bottom: 0;
    line-height: @navbarHeight;
  }
  // Buttons in navbar
  .btn,
  .btn-group {
    .navbarVerticalAlign(30px); // Vertically center in navbar
  }
  .btn-group .btn {
    margin-top: 0; // then undo the margin here so we don't accidentally double it
  }
}

// Navbar forms
.navbar-form {
  margin-bottom: 0; // remove default bottom margin
  .clearfix();
  input,
  select,
  .radio,
  .checkbox {
    .navbarVerticalAlign(30px); // Vertically center in navbar
  }
  input,
  select {
    display: inline-block;
    margin-bottom: 0;
  }
  input[type="image"],
  input[type="checkbox"],
  input[type="radio"] {
    margin-top: 3px;
  }
  .input-append,
  .input-prepend {
    margin-top: 6px;
    white-space: nowrap; // preven two  items from separating within a .navbar-form that has .pull-left
    input {
      margin-top: 0; // remove the margin on top since it's on the parent
    }
  }
}

// Navbar search
.navbar-search {
  position: relative;
  float: left;
  .navbarVerticalAlign(28px); // Vertically center in navbar
  margin-bottom: 0;
  .search-query {
    padding: 4px 9px;
    #font > .sans-serif(13px, normal, 1);
    color: @white;
    background-color: @navbarSearchBackground;
    border: 1px solid @navbarSearchBorder;
    @shadow: inset 0 1px 2px rgba(0,0,0,.1), 0 1px 0px rgba(255,255,255,.15);
    .box-shadow(@shadow);
    .transition(none);

    // Placeholder text gets special styles; can't be a grouped selector
    &:-moz-placeholder {
      color: @navbarSearchPlaceholderColor;
    }
    &::-webkit-input-placeholder {
      color: @navbarSearchPlaceholderColor;
    }

    // Focus states (we use .focused since IE7-8 and down doesn't support :focus)
    &:focus,
    &.focused {
      padding: 5px 10px;
      color: @grayDark;
      text-shadow: 0 1px 0 @white;
      background-color: @navbarSearchBackgroundFocus;
      border: 0;
      .box-shadow(0 0 3px rgba(0,0,0,.15));
      outline: 0;
    }
  }
}



// FIXED NAVBAR
// ------------

// Shared (top/bottom) styles
.navbar-fixed-top,
.navbar-fixed-bottom {
  position: fixed;
  right: 0;
  left: 0;
  z-index: @zindexFixedNavbar;
  margin-bottom: 0; // remove 18px margin for static navbar
}
.navbar-fixed-top .navbar-inner,
.navbar-fixed-bottom .navbar-inner {
  padding-left:  0;
  padding-right: 0;
  .border-radius(0);
}

.navbar-fixed-top .container,
.navbar-fixed-bottom .container {
  #grid > .core > .span(@gridColumns);
}

// Fixed to top
.navbar-fixed-top {
  top: 0;
}

// Fixed to bottom
.navbar-fixed-bottom {
  bottom: 0;
}



// NAVIGATION
// ----------

.navbar .nav {
  position: relative;
  left: 0;
  display: block;
  float: left;
  margin: 0 10px 0 0;
}
.navbar .nav.pull-right {
  float: right; // redeclare due to specificity
}
.navbar .nav > li {
  display: block;
  float: left;
}

// Links
.navbar .nav > li > a {
  float: none;
  padding: 10px 10px 11px;
  line-height: 19px;
  color: @navbarLinkColor;
  text-decoration: none;
  text-shadow: 0 -1px 0 rgba(0,0,0,.25);
}
// Hover
.navbar .nav > li > a:hover {
  background-color: @navbarLinkBackgroundHover; // "transparent" is default to differentiate :hover from .active
  color: @navbarLinkColorHover;
  text-decoration: none;
}

// Active nav items
.navbar .nav .active > a,
.navbar .nav .active > a:hover {
  color: @navbarLinkColorActive;
  text-decoration: none;
  background-color: @navbarLinkBackgroundActive;
}

// Dividers (basically a vertical hr)
.navbar .divider-vertical {
  height: @navbarHeight;
  width: 1px;
  margin: 0 9px;
  overflow: hidden;
  background-color: @navbarBackground;
  border-right: 1px solid @navbarBackgroundHighlight;
}

// Secondary (floated right) nav in topbar
.navbar .nav.pull-right {
  margin-left: 10px;
  margin-right: 0;
}

@import "responsive.less";
